<?php

    include "connect_db.php";

    $PostJSON = json_decode(file_get_contents('php://input'));

    function FieldSequence($fields, $conjunction, $trimstr) {
        foreach ($fields as $field) { $Sequence = $Sequence.$field.$conjunction; }
        return rtrim($Sequence, $trimstr);
    }

    switch ($PostJSON->SQLCommand) {
        case "SELECT":
            try {
                $stmt = $pdo->prepare("$PostJSON->SQLCommand ".FieldSequence($PostJSON->QueryFields, ", ", ", ")." FROM $PostJSON->TableName WHERE ".FieldSequence($PostJSON->FilterFields, " = ? AND ", " AND "));
                $stmt->execute($PostJSON->FilterValues);
                echo json_encode($stmt->fetchAll());
            } catch(PDOException $e) {
                echo '{"Error": true, "QueryType": "DataBase", "HTTPStatusCode": 993, "HTTPStatusText": "Bad SELECT query"}';
            }
            break;
        case "INSERT INTO":
            try {
                $stmt = $pdo->prepare("$PostJSON->SQLCommand $PostJSON->TableName (".FieldSequence($PostJSON->InsertFields, ", ", ", ").") VALUES (".rtrim(str_repeat("?, ", count($PostJSON->InsertFields)), ", ").")");
                $stmt->execute($PostJSON->InsertValues);
                echo '{"InsertID": "'.$pdo->lastInsertId().'", "InsertedRows": "'.$stmt->rowCount().'" }';
            } catch(PDOException $e) {
                echo '{"Error": true, "QueryType": "DataBase", "HTTPStatusCode": 994, "HTTPStatusText": "Bad INSERT INTO query"}';
            }
            break;
        case "UPDATE":
            try {
                $stmt = $pdo->prepare("$PostJSON->SQLCommand $PostJSON->TableName SET ".FieldSequence($PostJSON->UpdateFields, " = ?, ", ", ")." WHERE ".FieldSequence($PostJSON->FilterFields, " = ? AND ", " AND "));
                $stmt->execute(array_merge($PostJSON->UpdateValues, $PostJSON->FilterValues));
                echo '{"UpdatedRows": '.$stmt->rowCount().' }';
            } catch(PDOException $e) {
                echo '{"Error": true, "QueryType": "DataBase", "HTTPStatusCode": 995, "HTTPStatusText": "Bad UPDATE query"}';
            }
            break;
        case "DELETE":
            try {
                $stmt = $pdo->prepare("$PostJSON->SQLCommand FROM $PostJSON->TableName WHERE ".FieldSequence($PostJSON->FilterFields, " = ? AND ", " AND "));
                $stmt->execute($PostJSON->FilterValues);
                echo '{"DeletedRows": '.$stmt->rowCount().' }';
            } catch(PDOException $e) {
                echo '{"Error": true, "QueryType": "DataBase", "HTTPStatusCode": 996, "HTTPStatusText": "Bad DELETE query"}';
            }
            break;
        default:
            echo '{"Error": true, "QueryType": "DataBase", "HTTPStatusCode": 997, "HTTPStatusText": "Bad query (no: SELECT, INSERT INTO, UPDATE or DELETE statement)"}';
    }

?>