<?php
   session_start();
   echo isset($_SESSION["GSB-User"])."-".$_SESSION["GSB-User"];
?>
<!DOCTYPE HTML>

<html lang="hr">

   <head>

      <!--
       ________  _____            __________  _____    ________ 
      /   __   \/  _  \           \____    / /  _  \  /  _____/ 
      \____    /  /_\  \   ______   /     / /  /_\  \/   \  ___ 
         /    /    |    \ /_____/  /     /_/    |    \    \_\  \
        /____/\____|__  /         /_______ \____|__  /\______  /
                      \/                  \/       \/        \/ 
      -->

      <title>9A - GUITAR SONG BOOK</title>

      <meta http-equiv="Content-Type" content="text/html;charset=UTF-8" />
      <meta name="viewport" content="width=device-width, initial-scale=1.0"/>

      <link rel="stylesheet" type="text/css" href="https://fonts.googleapis.com/css?family=Roboto">
      <link rel="stylesheet" type="text/css" href="/global-resources/fonts/FontAwesome/fontawesome-pro-5.4.1-web/css/all.min.css">
       <link rel="stylesheet" type="text/css" href="../../resources/modal-window.css?v=<?php echo time(); ?>" />

      <script src="/global-resources/jquery-3.3.1.min.js"></script>
      <script src="../../resources/core.js"></script>
      <script type="text/javascript" src="../../resources/modal-window.js?v=<?php echo time(); ?>"></script>

      <style>

         html { 
            background: url(loginBg.jpg) no-repeat right center fixed; 
            font-family: Roboto, arial, helvetica, sans-serif;
            font-size: 14px;
          }

          * { box-sizing: border-box; }

          #loginForm {
              position: fixed;
              left: 0;
              top: 0;
              bottom: 0;
              padding: 15px;
              background: url(sb_logo.png) no-repeat left bottom;
              background-size: 97% auto;
              color: white;
          }
          
          #loginForm #login, #loginForm #register {
              display: block;
              color: #feb526;
              background-color: rgba(255, 255, 255, 0.2);
              margin: -15px -15px 15px -15px;
              padding: 10px 20px;
              text-align: center;
              font-size: 16px;
              font-weight: bold;
          }
          
          #loginForm .label {
              display: block;
              color: white;
              margin-bottom: 5px;
              padding-left: 20px;
          }
          
          #loginForm input[type=text], #loginForm input[type=password] {
              width: 100%;
              border: none;
              background-color: rgba(255, 255, 255, 0.3);
              border-radius: 50px;
              font-sze: 16px;
              color: white;
              outline: none;
              padding: 10px;
              margin-bottom: 15px;
          }

          input:-webkit-autofill,
          input:-webkit-autofill:hover,
          input:-webkit-autofill:focus,
          input:-webkit-autofill:active {
              background-color: rgba(255, 255, 255, 0.3);
              color: white;
              -webkit-transition: "color 9999s ease-out, background-color 9999s ease-out";
              -webkit-transition-delay: 9999s;
          }
    
          #loginForm input:focus {
              background-color: rgba(255, 255, 255, 0.5);
              outline: none;
              margin-bottom: 15px;
          }
          
          #loginForm img {
              position: absolute;
              bottom: 0;
              left: 0;
              width: 95%;
              height: auto;
          }

          #loginForm a {
              color: #feb526;
          }

          #loginForm #logMeIn {
              padding: 10px 20px;
              border: none;
              background-color: #feb526;
              color: white;
              border-radius: 50px;
              outline: none;
              min-width: 50%;
              text-align: center;
              cursor: pointer;
          }

          #loginForm #logMeIn:hover {
              background-color: white;
              color: black;
          }

          #loginForm .buttonHolder {
              margin: 15px 0 40px 0;
              text-align: right;
          }

          /* -------------------------------------------------------------------------- */
          /* MOBILE MODE: ------------------------------------------------------------- */
          /* -------------------------------------------------------------------------- */

          @media only screen and (max-width: 600px) {

             #loginForm {
                 width: 100%;
                 background-color: rgba(0, 0, 0, 0.7);
             }

          }

          /* -------------------------------------------------------------------------- */
          /* TABLET MODE: ------------------------------------------------------------- */
          /* -------------------------------------------------------------------------- */

          @media only screen and (min-width: 600px) and (max-width: 959px) {
          }

          /* -------------------------------------------------------------------------- */
          /* DESKTOP MODE: ------------------------------------------------------------ */
          /* -------------------------------------------------------------------------- */

          @media only screen and (min-width: 960px) {

             html {
                background: url(../../img/guitar-girl-bg.jpg) no-repeat right center fixed; 
                -webkit-background-size: cover;
                -moz-background-size: cover;
                -o-background-size: cover;
                background-size: cover;
                font-family: Roboto, arial, helvetica, sans-serif;
                font-size: 14px;
             }

             #loginForm {
                 width: 300px;
                 background-color: rgba(0, 0, 0, 0.5);
             }

          }

      </style>

      <script>

          if (location.protocol !== "https:") location.protocol = "https:";

          var cookies;

          $(document).ready(function() {

              $()._9A_MODAL("INITIALIZE", { });

              cookies = CookiesToObject({"todo": "CheckUser"});

              checkUser();

              $("#logMeIn").click(function(event) {

                 event.preventDefault();

                 $("#email").val($.trim($("#email").val()));

                 if($("#email").val() == "") {
                    
                    var data = { type: "warning",
                              "title": "Netočan unos...",
                            "heading": "Korisničko ime (e-mail):",
                           "paragraf": "unos je obavezan te na početku i na kraju ne može sadržavati razmaknice!",
                            "buttons": [ { "type": "fas fa-times-circle", "caption": "ZATVORI", "callback": "" } ]
                    };
                    
                    $()._9A_MODAL("SHOW", data);
                    
                    return;
                 
                 }

                 $("#password").val($.trim($("#password").val()));

                 if($("#password").val() == "") {
                    
                    var data = { type: "warning",
                              "title": "Netočan unos...",
                            "heading": "Zaporka:",
                           "paragraf": "unos je obavezan te na početku i na kraju ne može sadržavati razmaknice!",
                            "buttons": [ { "type": "fas fa-times-circle", "caption": "ZATVORI", "callback": "" } ]
                    };
                    
                    $()._9A_MODAL("SHOW", data);
                    
                    return;
                 
                 }
      
                 var object = FormToObject($("#loginForm"), {todo: "LogMeIn"});

                 $.get("manageUsers.php", object, function(data) {
                    data = JSON.parse(data);
                    if(data["Status"] == "OK") location.href = "https://www.9a-zag.com/webs/guitar_song_book/gsb-index.php";
                    else {
                       var data = { type: "warning",
                                 "title": "Netočan unos...",
                               "heading": "Korisničko ime (e-mail) i / ili zaporka:",
                              "paragraf": "ne postoji korisnik sa zadanim podacima!",
                               "buttons": [ { "type": "fas fa-times-circle", "caption": "ZATVORI", "callback": "" } ]
                       };
                    
                       $()._9A_MODAL("SHOW", data);
                    }
                 });
                 return false;
              });
              
              $("#remember").click(function() {
                  var object = FormToObject($("#loginForm"), {todo: "RememberMe"});
                  $.get("manageUsers.php", object, function(data) {
                     data = JSON.parse(data);
                     if(data["Status"] == "ERROR" || data["Value"] == "0") {
                        $("#email").val("");
                        $("#password").val("");
                     } else {
                         checkUser();
                     }
                  });
              });
          });

          function checkUser() {
              if(typeof cookies["GSB-User"] == "undefined") {
                 $("#remember").prop("checked", true);
                 $("#email").val("");
                 $("#password").val("");
              } else {
                  $.get("manageUsers.php", cookies, function(data) {
                     data = JSON.parse(data);
                     if(data["Status"] == "ERROR") {
                           $("#remember").prop("checked", false);
                           $("#password").val("");
                     } else {
                        $("#email").val(data["user_email"]);
                        if(parseInt(data["remember_me"]) == 1) {
                           $("#remember").prop("checked", true);
                           $("#password").val(data["ts"]);
                        } else {
                           $("#remember").prop("checked", false);
                           $("#password").val("");
                        }
                     }
                  });
              }
          }

      </script>

<script>
    
</script>

   </head>

   <body class="noselect">

      <form id="loginForm" enctype="application/json" autocomplete="off" autocorrect="off" autocapitalize="off" spellcheck="false">
          <span id="login">P R I J A V A</span>
          <span class="label">Korisničko ime (e-mail):</span>
          <input type="text" autocomplete="off" autocorrect="off" autocapitalize="off" spellcheck="false" name="email" id="email" />
          <span class="label">Zaporka:</span>
          <input type="password" autocomplete="off" autocorrect="off" autocapitalize="off" spellcheck="false" name="password" id="password" />
          <input type="checkbox" name="remember" id="remember" />Zapamti me na ovom uređaju<br /><br />
          <a href="#forgotten.php">Zaboravio sam zaporku...</a>
          <div class="buttonHolder"><button id="logMeIn">PRIJAVI SE...</button></div>
          <div>
              <span id="register">R E G I S T R A C I J A</span>
              Ako još niste postali naš član<br />možete se registrirati <a href="#register.php">ovdje...</a>
          </div>
          <!-- <img src="sb_logo.png" alt="" /> -->
      </form>

   </body>

</html>