
   var Note = ["C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "H"];
   var Kind = ["", "m"];
   var Adds = ["", "-5", "5", "6", "7", "9", "11", "13", "sus4", "sus2", "sus2sus4", "aug", "dim", "dim7", "maj7", "maj9", "maj11", "maj13", "maj7b5", "maj7#5", "maj9#11", "maj13#11", "add9", "6add9", "7b5", "7#5", "7b9", "7#9", "7(b5,b9)", "7(b5,#9)", "7(#5,b9)", "7(#5,#9)", "7sus4", "9b5", "9#5", "11b9", "13b9", "13#11"];

   var song = [
                 ["chord","2|0|0|1","7|0|0|14"],
                 ["verse","Zlatni konci litnje zore"],
             
    ["chord","9|0|8|1","9|0|0|7","11|1|0|13"],
                 ["verse","Dosli su u njene dvore"],
             
    ["chord","7|0|0|1","9|0|8|12","2|0|0|22"],
                 ["verse","Da bi moju jubav budili."],
                 ["chord","2|0|0|1","7|0|0|14"],
                 ["verse","Svitlo nek' joj jubi lice"],
             
    ["chord","9|0|8|1","9|0|0|7","11|1|0|13"],
                 ["verse","Lipo ka' u Cesarice"],
             
    ["chord","7|0|0|1","9|0|8|12","2|0|0|22"],
                 ["verse","Kad je ja ne mogu jubiti."],
                 ["chord","2|0|0|1","7|0|0|14"],
                 ["verse","Zlatna mriza njenog tila"],
             
    ["chord","9|0|8|1","9|0|0|7","11|1|0|13"],
                 ["verse","Dusu mi je uvatila"],
             
    ["chord","7|0|0|1","9|0|8|12","2|0|0|22"],
                 ["verse","Da je baci nazad u more."],
                 ["chord","2|0|0|1","7|0|0|14"],
                 ["verse","Svake noci prije zore"],
             
    ["chord","9|0|8|1","9|0|0|7","11|1|0|13"],
                 ["verse","Dolazim u njene dvore"],
             
    ["chord","7|0|0|1","9|0|8|12","2|0|0|22"],
                 ["verse","Bile dvore moje pokore."],
                 ["space","PRIPJEV:"],
             
    ["chord","2|0|0|1","7|0|0|22"],
                 ["verse","Cilega zivota ja sam tija samo nju"],
                 ["chord","9|0|0|1","2|0|0|25", "9|0|0|30"],
                 ["verse","Da do njenog srca naden put"],
             
    ["chord","6|0|0|1","1|1|0|20","7|0|0|32"],
                 ["verse","Cilega zivota moje tilo je bez nje"],
             
    ["chord","2|0|0|6","9|0|8|11","9|0|0|17","2|0|0|21"],
                 ["verse","Ka' cvice bez vode."],
                 ["space","***"],
                 ["chord","2|0|0|1","7|0|0|14"],
                 ["verse","Zlatna mriza njenog tila"],
             
    ["chord","9|0|8|1","9|0|0|7","11|1|0|13"],
                 ["verse","Dusu mi je uvatila"],
             
    ["chord","7|0|0|1","9|0|8|12","2|0|0|22"],
                 ["verse","Da je baci nazad u more."],
                 ["chord","2|0|0|1","7|0|0|14"],
                 ["verse","Svake noci prije zore"],
             
    ["chord","9|0|8|1","9|0|0|7","11|1|0|13"],
                 ["verse","Dolazim u njene dvore"],
             
    ["chord","7|0|0|1","9|0|8|12","2|0|0|22"],
                 ["verse","Bile dvore moje pokore."],
                 ["space","PRIPJEV:"],
             
    ["chord","2|0|0|1","7|0|0|22"],
                 ["verse","Cilega zivota ja sam tija samo nju"],
                 ["chord","9|0|0|1","2|0|0|25", "9|0|0|30"],
                 ["verse","Da do njenog srca naden put"],
             
    ["chord","6|0|0|1","1|1|0|20","7|0|0|32"],
                 ["verse","Cilega zivota moje tilo je bez nje"],
             
    ["chord","2|0|0|6","9|0|8|11","9|0|0|17","2|0|0|21"],
                 ["verse","Ka' cvice bez vode."],
                 ["space","***"],
             
    ["chord","2|0|0|6","9|0|8|11","9|0|0|17","2|0|0|21"],
                 ["verse","Ka' cvice bez vode."],
                 ["space","KRAJ"]

              ];

   $(document).ready(function() {
      ReadSong();
      $(document).delegate(".chord, .verse", "keyup", function() {
         $(".info").text($(this).attr("class") + ": " + $(this).attr("data-row"));
      });
      $(".song").keyup(function() {
         $(".bong").text($(".song").html());
      });
   });

   function ReadSong() {
      var TheSong=[];
      $.get( "../php/get_song.php", { ID: 1 } ).done(function(data) {
         TheSong = data.split("$");
         var chunk;
         for(var c = 0; c < TheSong.length; c++) {
            chunk = TheSong[c].split("%");
            if($.trim(chunk[0]) == "c") {
               $(".song").append('<span class="c" data-row="' + (c + 1) + '">' + GetChords(chunk, 2) + '</span>');
            }
            if($.trim(chunk[0]) == "v" || $.trim(chunk[0]) == "s") {
               $(".song").append('<span class="' + chunk[0] + '" data-row="' + (c + 1) + '">' + chunk[1] + '</span>');
            }
         }
      });
/*
      for(var c = 0; c < song.length; c++) {
         if(song[c][0] == "chord")
            $(".song").append('<div contenteditable="true" class="chord" data-row="' + (c + 1) + '">' + GetChords(song[c], 2) + '</div>');
         if(song[c][0] == "verse" || song[c][0] == "space")
            $(".song").append('<div contenteditable="true" class="' + song[c][0] + '" data-row="' + (c + 1) + '">' + song[c][1] + '</div>');
      }
*/
   }

   function GetChords(Template, Translate) {
      var OutChords = "";
      var SplChords = [];
      var AddChord  = "";
      var NumSpaces = 0;
      var StrSpaces = 0;
      var NoteNum   = 0;
      for(var i = 1; i < Template.length; i++) {
         SplChords = Template[i].split("|");
         if(SplChords[0].indexOf("/") > -1) {
            var splits = SplChords[0].split("/");
            if(isInt(splits[0])) {
               NoteNum  = parseInt(splits[0]) + Translate;
               if(NoteNum >= Note.length) NoteNum = NoteNum - Note.length;
               AddChord = Note[NoteNum] + "/";
            } else AddChord = splits[0] + "/";
            if(isInt(splits[1])) {
               NoteNum  = parseInt(splits[1]) + Translate;
               if(NoteNum >= Note.length) NoteNum = NoteNum - Note.length;
               AddChord = AddChord + Note[NoteNum];
            } else AddChord = AddChord + splits[1];
         } else {
            NoteNum = parseInt(SplChords[0]) + Translate;
            if(NoteNum >= Note.length) NoteNum = NoteNum - Note.length;
            AddChord  = Note[NoteNum]
                      + Kind[parseInt(SplChords[1])]
                      + Adds[parseInt(SplChords[2])];
         }
         NumSpaces = parseInt(SplChords[3]) - 1 - OutChords.length;
         for(StrSpaces = ""; StrSpaces.length < NumSpaces; StrSpaces += " "){}
         OutChords = OutChords + StrSpaces + AddChord;
      }
      return OutChords;
   }

   function AnalyseText() {
      var tags = ["p", "span", "div", "li"];
      var found = [0, 0, 0, 0];
      $(tags).each(function(Index) { found[Index] = $(".paste").find(tags[Index]).length; });
      var MaxPos = found.indexOf(Math.max.apply(Math, found));
      alert(found[0] + "\n" + found[1] + "\n" + found[2] + "\n" + found[3] + "\n" + MaxPos);
      var re = /\r\n|\n\r|\n|\r/g;
      var Lines = $(".paste").text().replace(re,"\n").split("\n");
      var retval = [];
      if(found[MaxPos] != 0 && found[MaxPos] > Lines.length && false) {
         $(".paste " + tags[MaxPos]).each(function(Index) {
            retval = AnalyseLine($(this).text());
            if(retval.length > 0) {
               for(var i = 0; i < retval.length; i++) {
                  alert("A: " + retval[i]);
               }
            }
         });
      } else {
         $(Lines).each(function(Index) {
            retval = AnalyseLine(Lines[Index]);
            if(retval.length > 0) {
               for(var i = 0; i < retval.length; i++) {
                  alert(retval[i]);
               }
            }
         });
      }
   }

   function AnalyseLine(Line) {
      var blocks = Line.split(" "); //.filter(function(n){ return n != "" });
      var chord  = 0;
      var chords = 0;
      var chknd  = 0;
      var chadd  = 0;
      var tries  = 0;
      var retval = ["unknown"];
      var chordLine = "";
      var pos    = 0;
      for(var b = 0; b < blocks.length; b++) {
         pos = pos + 1;
         if(blocks[b] == "") continue;
         tries = tries + 1;
         if(blocks[b].indexOf("/") > -1) {
            var splitted = blocks[b].split("/");
            var OutCh = "";
            var isCh  = false;
            var NoteFound = $.inArray(splitted[0], Note);
            if(NoteFound == -1) OutCh = splitted[0] + "/";
            else {
               isCh = true;
               OutCh = NoteFound + "/";
            }
            NoteFound = $.inArray(splitted[1], Note);
            if(NoteFound == -1) {
               isCh = false;
               OutCh = OutCh + splitted[1];
            }
            else  OutCh = OutCh + NoteFound;
            if(isCh) chords = chords + 1;
            chordLine = OutCh + "|0|0|" + pos;
            retval.push(chordLine);
            pos = pos + OutCh.length;
            continue;
         }
         chord  = 0;
         chknd  = 0;
         chadd  = 0;
         for(var n=0; n < Note.length; n++) {
            if(blocks[b] == Note[n]) {
               chord = n;
               chknd = 0;
               chadd = 0;
               // pos = pos + Note[n].length;
               break;
            }
            for(var k=0; k < Kind.length; k++) {
               if(blocks[b] == Note[n] + Kind[k]) {
                  chord = n;
                  chknd = k;
                  chadd = 0;
                  // pos = pos + (Note[n] + Kind[k]).length;
                  break;
               }
               for(var a=0; a < Adds.length; a++) {
                  if(blocks[b] == Note[n] + Kind[k] + Adds[a]) {
                     chord = n;
                     chknd = k;
                     chadd = a;
                     // pos = pos + (Note[n] + Kind[k] + Adds[a]).length;
                     break;
                  }
               }
               if(chord > 0) break;
            }
            if(chord > 0) break;
         }
         if(chord > 0) {
            chords    = chords + 1;
            chordLine = chord + "|" + chknd + "|" + chadd + "|" + pos;
            retval.push(chordLine);
            if(chord > 0) pos = pos + Note[n].length;
            if(chknd > 0) pos = pos + Kind[k].length;
            if(chadd > 0) pos = pos + Adds[a].length;
         }
      }
      if(chords == 0) { retval[0] = "verse"; retval[1] = Line; }
      if(tries == chords && chords > 0) retval[0] = "chords";
      if(chords > 0 && chords < tries)  retval[0] = "unknown";
      return retval;
   }

   function isInt(value) { var er = /^-?[0-9]+$/; return er.test(value); }
/*
c%2|0|0|1%7|0|0|14$
v%Zlatni konci litnje zore$
c%9|0|8|1%9|0|0|7%11|1|0|13$
v%Dosli su u njene dvore$
c%7|0|0|1%9|0|8|12%2|0|0|22$
v%Da bi moju jubav budili.$
c%2|0|0|1%7|0|0|14$
v%Svitlo nek' joj jubi lice$
c%9|0|8|1%9|0|0|7%11|1|0|13$
v%Lipo ka' u Cesarice$
c%7|0|0|1%9|0|8|12%2|0|0|22$
v%Kad je ja ne mogu jubiti.$
c%2|0|0|1%7|0|0|14$
v%Zlatna mriza njenog tila$
c%9|0|8|1%9|0|0|7%11|1|0|13$
v%Dusu mi je uvatila$
c%7|0|0|1%9|0|8|12%2|0|0|22$
v%Da je baci nazad u more.$
c%2|0|0|1%7|0|0|14$
v%Svake noci prije zore$
c%9|0|8|1%9|0|0|7%11|1|0|13$
v%Dolazim u njene dvore$
c%7|0|0|1%9|0|8|12%2|0|0|22$
v%Bile dvore moje pokore.$
s%PRIPJEV:$
c%2|0|0|1%7|0|0|22$
v%Cilega zivota ja sam tija samo nju$
c%9|0|0|1%2|0|0|25% 9|0|0|30$
v%Da do njenog srca naden put$
c%6|0|0|1%1|1|0|20%7|0|0|32$
v%Cilega zivota moje tilo je bez nje$
c%2|0|0|6%9|0|8|11%9|0|0|17%2|0|0|21$
v%Ka' cvice bez vode.$
s%***$
c%2|0|0|1%7|0|0|14$
v%Zlatna mriza njenog tila$
c%9|0|8|1%9|0|0|7%11|1|0|13$
v%Dusu mi je uvatila$
c%7|0|0|1%9|0|8|12%2|0|0|22$
v%Da je baci nazad u more.$
c%2|0|0|1%7|0|0|14$
v%Svake noci prije zore$
c%9|0|8|1%9|0|0|7%11|1|0|13$
v%Dolazim u njene dvore$
c%7|0|0|1%9|0|8|12%2|0|0|22$
v%Bile dvore moje pokore.$
s%PRIPJEV:$
c%2|0|0|1%7|0|0|22$
v%Cilega zivota ja sam tija samo nju$
c%9|0|0|1%2|0|0|25% 9|0|0|30$
v%Da do njenog srca naden put$
c%6|0|0|1%1|1|0|20%7|0|0|32$
v%Cilega zivota moje tilo je bez nje$
c%2|0|0|6%9|0|8|11%9|0|0|17%2|0|0|21$
v%Ka' cvice bez vode.$
s%***$
c%2|0|0|6%9|0|8|11%9|0|0|17%2|0|0|21$
v%Ka' cvice bez vode.$
s%KRAJ
*/