
   var UserID = 3;
   var User = 3;

   var Note = ["C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "H"];
   var Notb = ["", "Db", "", "Eb", "", "", "Gb", "", "Ab", "", "Hb", ""];
   var Mins = ["c", "c#", "d", "d#", "e", "f", "f#", "g", "g#", "a", "a#", "h", "db", "eb", "gb", "ab", "hb", "bb", "b"];
   var Notx = ["", "", "", "", "", "", "", "", "", "", "Bb", "B"];
   var Kind = ["", "m"];
   var Adds = ["7(#5,#9)", "7(#5,b9)", "7(b5,#9)", "7(b5,b9)", "maj13#11", "sus2sus4", "maj9#11", "maj7#5", "maj7b5", "7sus4", "6add9", "13#11", "maj13", "maj11", "maj9", "dim7", "13b9", "sus2", "add9", "sus4", "maj7", "11b9", "aug", "7b5", "7#5", "dim", "7#9", "7b9", "9#5", "9b5", "11", "13", "-5", "7", "6", "9", "5", "3"];

   $(window).resize(function() { setTimeout(function(){ DoResize(); }, 250); });

   $(document).ready(function() {

      window.resizedFinished = setTimeout(function(){ DoResize(); }, 250); /* FIX browser lazy resizing. */

      $(document).delegate("a", "click", function() { $(".ToolTip").remove(); });

      $(document).on( {
         mouseenter: function() {
            var ToolTip = $(this).attr('data-tip');
            $('<span class="ToolTip"></span>').text(ToolTip)
               .appendTo('body')
               .css('top',  (event.pageY + 20) + 'px')
               .css('left', (event.pageX - 20) + 'px')
               .fadeIn('slow');
            var overflow = parseInt($(".ToolTip").css("left")) + parseInt($(".ToolTip").width());
            if(overflow > $(window).width() - 20)
               $(".ToolTip").css("left", ($(window).width() - $(".ToolTip").width()) - 40 + "px")
         },
         mouseleave: function() { $(".ToolTip").remove(); }
      }, ".tt");

      $("#tabulator_headers a").click(function() {

         $("#tabulator_headers a").removeClass("active");
         $(".contentbox").hide();
         $(this).addClass("active");
         $($(this).attr("href")).show();
         DoResize();
      });

   });

   function PlayLists_Get() { /* Get list of playlists from database. */
      $.post( "../php/do_playlists.php", { todo: 0, user: User } ).done(function(data) {
         PlayLists_Create(data);
      });
   }

   function GetLetterFilter(obj) {
      $.post("../php/get_letter_filter.php").done(function(data) {
         if(data == "") return;
         var Letters = jQuery.parseJSON(data);
         for(var ls = 0; ls < Letters.length; ls++) {
            var lcClass = (parseInt(Letters[ls]["C"]) == 0 ? "empty" : "some");
            $(obj).append("<a href='#' class='" + lcClass + "' data-letter='" + Letters[ls]["L"] + "' data-count='" + Letters[ls]["C"] + "'>" + Letters[ls]["L"] + "</a>");
         }
         DoResize();
         $(obj).children("a").click(function() { 
            $(obj).children("a").removeClass("active");
            $(this).addClass("active");
            GetArtists($("#lc_ArtistList"), $(this).attr("data-letter"));
         });
      });
   }

   function GetFilteredSongs(id, obj) {

      $.post("../php/songs_get.php", { Artist_ID: id } ).done(function(data) {
         var FilteredSongsHTML;
         if(data == "") return;
         var FilteredSongs = jQuery.parseJSON(data);
         if(FilteredSongs && FilteredSongs.Error)
            $(obj).html("<div class='InFrameMessage'>" + FilteredSongs.Error + "</div>");
         else {
            FilteredSongsHTML = "";
            for(var fs = 0; fs < FilteredSongs.length; fs++) {
               FilteredSongsHTML = "<a href='#" + FilteredSongs[fs]["Song_ID"] + "' class='song_item'>"
                                 + "   <span class='artist' data-artist='" + FilteredSongs[fs]["Artist_ID"] + "'>" + FilteredSongs[fs]["Artist_Name"] + "</span>"
                                 + "   <span class='song' data-song='" + FilteredSongs[fs]["Song_ID"] + "'>" + FilteredSongs[fs]["Song_Title"] + "</span>"
                                 + "</a>";     // FilteredSongsHTML + FilteredSongs[fs]["Song_Title"] + "<br />";
               $(obj).append(FilteredSongsHTML);
            }
            $(obj).children("a").click(function() { 
               $(obj).children("a").removeClass("active");
               $(this).addClass("active");
               SelectedSong = $(this);
               SongClick($(this).attr("href").split("#")[1]);
            });
            $(obj).children("a").dblclick(function() { 
               $(obj).children("a").removeClass("active");
               $(this).addClass("active");
               SelectedSong = $(this);
               if (typeof SongEnter == "function") { 
                  SongEnter($(this).attr("href").split("#")[1]);
               }
               
            });
         }
      });
   }

   function GetArtists(obj, letter) {
      var OutLetter = letter;
      if(letter == "*") OutLetter = "";
      $.post( "../php/artists_get.php", { lc: OutLetter }).done(function(data) {
         if(data == "") return;
         var Artists = jQuery.parseJSON(data);
         var DataDo;
         $(obj).html("");
         if(Artists.length == 0)
            $(obj).html("<div class='InFrameMessage'>No artists available.</div>");
         else {
            if(letter == "") DataDo = 1;
            else DataDo = 2;
            for(var ga = 0; ga < Artists.length; ga++) {
               $(obj).append("<a data-do='" + DataDo + "' href='#" + Artists[ga]["Artist_ID"] + "'>" + Artists[ga]["Artist_Name"] + "</a>");
            }
            $(obj).children("a").click(function() {
               $(obj).children("a").removeClass("active");
               $(this).addClass("active");
               if($(this).attr("data-do") == 1) SelectedArtist = $(this);
               ArtistClick($(this));
            });
            $(obj).children("a").dblclick(function() {
               $(obj).children("a").removeClass("active");
               $(this).addClass("active");
               if($(this).attr("data-do") == 1) SelectedArtist = $(this);
               if (typeof ArtistEnter == "function") {
                  ArtistEnter($(this));
               }
            });
         }
      });
   }

   function GetChords(Template, Translate) {
      var OutChords = "";
      var SplChords = [];
      var AddChord  = "";
      var NumSpaces = 0;
      var StrSpaces = 0;
      var NoteNum   = 0;
      for(var i = 1; i < Template.length; i++) {
         SplChords = Template[i].split("|");
         if(SplChords[0].indexOf("/") > -1) {
            var splits = SplChords[0].split("/");
            if(isInt(splits[0])) {
               if(splits[0] == -1) AddChord = "";
               else {
                  NoteNum  = parseInt(splits[0]) + parseInt(Translate);
                  if(NoteNum >= Note.length) NoteNum = NoteNum - Note.length;
                  AddChord = Note[NoteNum] + "/";
               }
            } else AddChord = splits[0] + "/";
            if(isInt(splits[1])) {
               if(splits[1] == -1) AddChord = "";
               else {
                  NoteNum  = parseInt(splits[1]) + parseInt(Translate);
                  if(NoteNum >= Note.length) NoteNum = NoteNum - Note.length;
                  AddChord = AddChord + Note[NoteNum];
               }
            } else AddChord = AddChord + splits[1];
         } else {
            NoteNum = parseInt(SplChords[0]) + parseInt(Translate);
            if(NoteNum >= Note.length) NoteNum = NoteNum - Note.length;
            AddChord  = Note[NoteNum]
                      + (SplChords[1] == -1 ? "" : Kind[1])
                      + (SplChords[2] == -1 ? "" : Adds[parseInt(SplChords[2])]);
         }
         NumSpaces = parseInt(SplChords[3]) - 1 - OutChords.length;
         for(StrSpaces = ""; StrSpaces.length < NumSpaces; StrSpaces += " "){}
         OutChords = OutChords + StrSpaces + AddChord;
      }
      return OutChords;
   }

