
   var Note = ["C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "H"];
   var Notb = ["", "Db", "", "Eb", "", "", "Gb", "", "Ab", "", "Hb", ""];
   var Mins = ["c", "c#", "d", "d#", "e", "f", "f#", "g", "g#", "a", "a#", "h", "db", "eb", "gb", "ab", "hb", "bb", "b"];
   var Notx = ["", "", "", "", "", "", "", "", "", "", "Bb", "B"];
   var Kind = ["", "m"];
   var Adds = ["7(#5,#9)", "7(#5,b9)", "7(b5,#9)", "7(b5,b9)", "maj13#11", "sus2sus4", "maj9#11", "maj7#5", "maj7b5", "7sus4", "6add9", "13#11", "maj13", "maj11", "maj9", "dim7", "13b9", "sus2", "add9", "sus4", "maj7", "11b9", "aug", "7b5", "7#5", "dim", "7#9", "7b9", "9#5", "9b5", "11", "13", "-5", "7", "6", "9", "5"];

   $(document).ready(function() {
      $("#source").on("input propertychange", function() {
         TheSong = "";
         var Converted = "";
         var lines = $(this).val().split("\n");
         $(this).html("");
         for(var i = 0; i < lines.length; i++) { Converted = Converted + AnalyseLine(lines[i]); }
         // $("#output").text(TheSong);
         ReadSong(TheSong);
      });
   });

   function AnalyseLine(Line) {
      var blocks  = Line.split(" ");
      var IsChord = [];
      var Failed  = false;
      var ChPos   = 0;
      var Dest    = "";
      var Out     = "";
      for(var b = 0; b < blocks.length; b++) {
         ChPos++;
         if(blocks[b] == "") {
            Dest = Dest + " ";
            continue;
         }
         Dest = Dest + " ";
         if(blocks[b].indexOf("/") != -1) {
            var DC = blocks[b].split("/");
            IsChord = RecognizeChord(DC[0]);
            if(IsChord[0]) {
               Dest = Dest + IsChord[1][0] + IsChord[2][1] + IsChord[3][1] + "\\";
               Out = Out + "%" + IsChord[1][1] + "|" + IsChord[2][2] + "|" + IsChord[3][2] + "|";
            }
            IsChord = RecognizeChord(DC[1]);
            Dest = Dest + IsChord[1][0] + IsChord[2][1] + IsChord[3][1];
            Out = Out + IsChord[1][1] + "|" + IsChord[2][2] + "|" + IsChord[3][2] + "|" + ChPos;
            ChPos = ChPos + blocks[b].length;
            continue;
         }
         var IsChord = RecognizeChord(blocks[b]);
         if(IsChord[0]) {
            Dest = Dest + IsChord[1][0] + IsChord[2][1] + IsChord[3][1];
            Out = Out + "%" + IsChord[1][1] + "|" + IsChord[2][2] + "|" + IsChord[3][2] + "|" + ChPos;
            ChPos = ChPos + blocks[b].length;
         }
         else {
             Dest = Line + "\n";
             Failed = true;
             break;
         }
      }
      if(!Failed) {
         Dest = Dest + "\n";
         Out = "cc" + Out + "$\n";
      } else Out = "vv%" + Out + Line + "$\n";
      TheSong = TheSong + Out;
      return Dest;
   }
   
   function RecognizeChord(ChordToRecognize) {
      var Add      = "";
      var Minor    = "";
      var Chord    = "";
      var AddIdx   = 0;
      var MinorIdx = 0;
      var ChordIdx = 0;
      var GA = GetAdd(ChordToRecognize);
      var GM = GetMinor(GA[0]);
      var MC = MainChord(GM[0]);
      if(MC[1] == -1) return [false];
      else return[true, MC, GM, GA];
      function GetAdd(InChord) {
         OutChord  = InChord;
         OutAdd    = "";
         OutAddIdx = -1;
         for(var a = 0; a < Adds.length; a++) {
            var n = InChord.toLowerCase().lastIndexOf(Adds[a]);
            if(n != -1) {
               OutAddIdx = a;
               OutAdd    = Adds[a];
               OutChord  = InChord.substring(0, n);
               break;
            }
         }
         return [OutChord, OutAdd, OutAddIdx];
      }

      function GetMinor(InChord) {
         OutChord    = InChord;
         OutMinor    = "";
         OutMinorIdx = -1;
         var m = InChord.charAt(InChord.length - 1).toLowerCase();
         if(m == "m") {
            OutChord    = InChord.substring(0, InChord.length - 1);
            OutMinorIdx = 0;
            OutMinor    = "m";
         }

         if($.inArray(OutChord, Mins) != -1) {
            OutChord = OutChord[0].toUpperCase() + OutChord.slice(1);
            OutMinorIdx = 0;
            OutMinor    = "m";
         }
         return [OutChord, OutMinor, OutMinorIdx];
      }
      function MainChord(InChord) {
         OutChord    = InChord;
         OutChordIdx = -1;
         for(var c = 0; c < Note.length; c++) {
            if(Note[c] == InChord
            || Notb[c] == InChord
            || Notx[c] == InChord) {
               OutChordIdx = c;
               OutChord    = Note[c];
               break;
            }
         }        
         return [OutChord, OutChordIdx];
      }
   }

   function ReadSong() {
      var Line;
      var InRead = "";
      var OneRow = "";
      $("#read").text("");
      TheSong = TheSong.replace("\n", "").split("$");
      for(var s = 0; s < TheSong.length - 1; s++) {
         Line = TheSong[s].split("%");
         OneRow = "";
         if($.trim(Line[0]) == "cc") {
            for(var x = 1; x < Line.length; x++) {
               OneRow = OneRow + LineOut(Line[x], OneRow.length);
            }
         } else OneRow = OneRow + Line[1]; // + "\n";
         InRead = InRead +  OneRow + "\n";
      }
      $("#read").append(InRead);
   }

   function LineOut(InLine, InLen) {
      var TempChord = InLine.split("|");
      var OutChord = FindChord(TempChord[0], TempChord[1], TempChord[2]);
      var NSpaces  = TempChord[3] - InLen - 1;
      var Spaces   = "";
      if(TempChord.length == 7) {
         OutChord = OutChord + "/" + FindChord(TempChord[3], TempChord[4], TempChord[5]);
         NSpaces = TempChord[6] - InLen - 1;
      }
      for(var sp = 0; sp < NSpaces; sp++) { Spaces = Spaces + " "; }
      return (Spaces == "" ? " " : Spaces) + OutChord;
      function FindChord(c, m, a) {
         return(Note[c] + (parseInt(m) == 0 ? "m" : "") + (parseInt(a) == -1 ? "" : Adds[a]));
      }
   }