
   function attachEvents() {

      // KEYBOARD EVENTS --------------------------------------------------------------

      $(document).keydown(function(e) {

         // console.log(e.keyCode);

         if(e.keyCode == 75 && e.ctrlKey && e.altKey) {

            KeyControlEnabled = !KeyControlEnabled;

            $("#Letters, #ArtistToolbar, #SongToolbar").removeClass("KeyboardON1R, KeyboardOFF1R");
            $("#Artists, #ArtistAddEditDelete, #Songs, #SongAddEditDelete").removeClass("KeyboardON2R, KeyboardOFF2R");

            if(KeyControlEnabled) {
               $("#Letters, #ArtistToolbar, #SongToolbar").addClass("KeyboardON1R");
               $("#Artists, #ArtistAddEditDelete, #Songs, #SongAddEditDelete").addClass("KeyboardON2R");
               $(".SectionMarker").show();
            } else {
               $(".SectionMarker").hide();
               $("#Letters, #ArtistToolbar, #SongToolbar").addClass("KeyboardOFF1R");
               $("#Artists, #ArtistAddEditDelete, #Songs, #SongAddEditDelete").addClass("KeyboardOFF2R");
            }
            return;
         }

         $("#ArtistAddInput").keydown(function(e) {
            if(e.keyCode === 13 && KeyControlEnabled) $("#ConfirmAddArtist").click();
            if(e.keyCode === 27 && KeyControlEnabled) controlArtist("CANCEL");
         });

         $("#ArtistEditInput").keydown(function(e) {
            if(e.keyCode === 13 && KeyControlEnabled) $("#ConfirmEditArtist").click();
            if(e.keyCode === 27 && KeyControlEnabled) controlArtist("CANCEL");
         });

         $("#SongAddInput").keydown(function(e) {
            if(e.keyCode === 13 && KeyControlEnabled) $("#YTIDAddInput").focus();
            if(e.keyCode === 27 && KeyControlEnabled) controlSong("CANCEL");
         });

         $("#SongEditInput").keydown(function(e) {
            if(e.keyCode === 13 && KeyControlEnabled) $("#YTIDEditInput").focus();
            if(e.keyCode === 27 && KeyControlEnabled) controlSong("CANCEL");
         });

         $("#YTIDAddInput").keydown(function(e) {
            if(e.keyCode === 13 && KeyControlEnabled) $("#ConfirmAddSong").click();
            if(e.keyCode === 27 && KeyControlEnabled) controlSong("CANCEL");
         });

         $("#YTIDEditInput").keydown(function(e) {
            if(e.keyCode === 13 && KeyControlEnabled) $("#ConfirmEditSong").click();
            if(e.keyCode === 27 && KeyControlEnabled) controlSong("CANCEL");
         });

         if(KeyControlEnabled) {

            if(e.keyCode == 13 && ActiveSection == 1 && !EditPending) { controlArtist("EDIT"); }

            if(e.keyCode == 13 && ActiveSection == 2 && !EditPending) { controlSong("EDIT"); }

            if(e.keyCode == 37) {
               if(ActiveSection == 0 || EditPending) return;
               ActiveSection--;
               $(".SectionMarker").removeClass("active");
               $("#" + Sections[ActiveSection]).addClass("active");
            }

            if(e.keyCode == 39) {
               if(ActiveSection == 2 || EditPending) return;
               ActiveSection++;
               $(".SectionMarker").removeClass("active");
               $("#" + Sections[ActiveSection]).addClass("active");
               if(ActiveSection == 1 && $("#Artists button").length > 0) $("#Artists button:first-child").click();
               if(ActiveSection == 2 && $("#Songs button").length > 0) $("#Songs button:first-child").click();
            }

            if(e.keyCode == 107 && !EditPending) {
               if(ActiveSection == 1) controlArtist("ADD");
               if(ActiveSection == 2) controlSong("ADD");
            }

            if(e.keyCode == 109 && !EditPending) {
               if(ActiveSection == 1) controlArtist("DELETE");
               if(ActiveSection == 2) controlSong("DELETE");
            }

            if(e.keyCode == 38 && !EditPending) {

               if(ActiveSection == 0) {
                  if($("#Letters button.active").length == 0) {
                     $("#Letters button:first-child").click();
                     return;
                  }
                  $("#Letters button.active").prev().click();
               }

               if(ActiveSection == 1) {
                  if($("#Artists button.active").length == 0) {
                     $("#Artists button:first-child").click();
                     return;
                  }
                  $("#Artists button.active").prev().click();
               }

               if(ActiveSection == 2) {
                  if($("#Songs button.active").length == 0) {
                     $("#Songs button:first-child").click();
                     return;
                  }
                  $("#Songs button.active").prev().click();
               }
            }

            if(e.keyCode == 40 && !EditPending) {

               if(ActiveSection == 0) {
                  if($("#Letters button.active").length == 0) {
                     $("#Letters button:first-child").click();
                     return;
                  }
                  $("#Letters button.active").next().click();
               }

               if(ActiveSection == 1) {
                  if($("#Artists button.active").length == 0) {
                     $("#Artists button:first-child").click();
                     return;
                  }
                  $("#Artists button.active").next().click();
               }

               if(ActiveSection == 2) {
                  if($("#Songs button.active").length == 0) {
                     $("#Songs button:first-child").click();
                     return;
                  }
                  $("#Songs button.active").next().click();
               }
            }
         }
      });

      // ARTIST EVENTS ----------------------------------------------------------------

      $("#ArtistAdd").click(function() { controlArtist("ADD"); });
      $("#ArtistEdit").click(function() { controlArtist("EDIT"); });
      $("#ArtistDelete").click(function() { controlArtist("DELETE"); });
      $(".ArtistCancel").click(function() { controlArtist("CANCEL"); });
      $("#ConfirmAddArtist").click(function() { manageArtist("ADD-A", $("#ArtistAddInput").val(), 4); });
      $("#ConfirmEditArtist").click(function() { manageArtist("EDIT-A", $("#ArtistEditInput").val(), 5); });
      $("#ConfirmDeleteArtist").click(function() { manageArtist("DELETE-A", SelectedArtistName, 3); });

      // SONG EVENTS ------------------------------------------------------------------

      $("#SongAdd").click(function() { controlSong("ADD"); });
      $("#SongEdit").click(function() { controlSong("EDIT"); });
      $("#SongDelete").click(function() { controlSong("DELETE"); });
      $(".SongCancel").click(function() { controlSong("CANCEL"); });
      $("#ConfirmAddSong").click(function() { manageSong("ADD-S", $("#SongAddInput").val(), $("#YTIDAddInput").val(), 4); });
      $("#ConfirmEditSong").click(function() { manageSong("EDIT-S", $("#SongEditInput").val(), $("#YTIDEditInput").val(), 5); });
      $("#ConfirmDeleteSong").click(function() { manageSong("DELETE-S", SelectedSongName, 3); });
      $("#SongTune").click(function() {
          if(EditPending) {
              firstSaveWork();
              return;
          }
          if(!SelectedSong) return;
          parent.toggleToTSEditor(SelectedSong);
      });

   }