
$(document).ready(function () {
   readJSON();
   $(document).delegate("button", "click", function() {
      $("button").removeClass("active");
      $(this).addClass("active");
      $(this).children("[data-class='endBrace']").toggle();
      $(this).next("ul").toggle();
      $(".endTagActive ").removeClass("endTagActive");
      if($(this).attr("data-class") === "itemButton") {
         $(this).closest("ul").children("[data-class='closeTag']").addClass("endTagActive");
      } else {
         $(this).next("ul").children("[data-class='closeTag']").addClass("endTagActive");
      }
   });
});

   var json, ul = -1, li = -1, bt = -1, braces = [["{", "}"], ["[", "]"]];

   function readJSON() {
      $.get("config.json?" + Date.now().toString(), function(json) {
         // json = JSON.parse(data);
         createTree(json, document.getElementById("editContainer"));
         $("pre.preJSON").text(JSON.stringify(json, undefined, 3));
         $("pre.preHTML").text(style_html($("#editContainer").html()));
         // let result = jsonPath(json, "$.Children.*~");
         const result = JSONPath.JSONPath({path: "$.Children.*~", json: json});
         const children = JSONPath.JSONPath({path: "$.Children[" + result[0] + "].Children.*~", json: json});
         $("pre.preTEST").text(children);
         // $("pre.preTEST").text(JSON.stringify(result, undefined, 3));
      });
   }

   function createTree(json, insertObj) {
      if(ul === -1) {
         ul++;
         var elementUL = document.createElement("UL")
         elementUL.setAttribute("data-id", "ul-" + ul);
         insertObj.appendChild(elementUL);
         createTree(json, elementUL);
         return;
      }
      $.each(json, function (i, item) {
         switch($.type(item).toUpperCase()) {
            case "OBJECT":
            case "ARRAY":
               var getBraces = ($.type(item).toUpperCase() === "OBJECT" ? 0 : 1);
               li++; bt++; ul++;
               var elementLI = document.createElement("LI");
               elementLI.setAttribute("data-id", "li-" + li);
               var elementBT = document.createElement("BUTTON");
               elementBT.setAttribute("data-id", "bt-" + bt);
               elementBT.setAttribute("data-class", "folderButton");
               var elementIC = document.createElement("I");
               elementIC.setAttribute("class", "fas fa-folder");
               elementBT.appendChild(elementIC);
               elementBT.appendChild(document.createTextNode(" " + i + " " + braces[getBraces][0]));
               var elementSP = document.createElement("SPAN");
               elementSP.setAttribute("data-class", "endBrace");
               elementSP.appendChild(document.createTextNode("..." + braces[getBraces][1]));
               elementBT.appendChild(elementSP);
               elementLI.appendChild(elementBT);
               insertObj.appendChild(elementLI);
               var elementUL = document.createElement("UL")
               elementUL.setAttribute("data-id", "ul-" + ul);
               elementLI.appendChild(elementUL);
               createTree(item, elementUL);
               li++;
               elementLI = document.createElement("LI");
               elementLI.setAttribute("data-class", "closeTag");
               elementLI.appendChild(document.createTextNode(braces[getBraces][1] + " "));
               elementSP = document.createElement("SPAN");
               elementSP.appendChild(document.createTextNode(i));
               elementLI.appendChild(elementSP);
               elementUL.appendChild(elementLI);
               break;
            case "STRING":
            case "NUMBER":
            case "BOOLEAN":
            case "NULL":
               li++; bt++;
               var elementLI = document.createElement("LI");
               elementLI.setAttribute("data-id", "li-" + li);
               var elementBT = document.createElement("BUTTON");
               elementBT.setAttribute("data-id", "bt-" + bt);
               elementBT.setAttribute("data-class", "itemButton");
               var elementIC = document.createElement("I");
               elementIC.setAttribute("class", "far fa-file");
               elementBT.appendChild(elementIC);
               elementBT.appendChild(document.createTextNode(" " + i + ": "));
               var elementSP = document.createElement("SPAN");
               elementSP.setAttribute("data-class", "data");
               elementSP.appendChild(document.createTextNode(item));
               elementBT.appendChild(elementSP);
               elementLI.appendChild(elementBT);
               insertObj.appendChild(elementLI);
               break;
            default:
            console.log($.type(item));
         }
      });
   }
